<?php

declare(strict_types=1);

namespace Core\General\Translation\ValueObject;

readonly class TranslationTuple
{
    /** @param array<string, mixed> $params */
    public function __construct(
        private string $message,
        private array $params = [],
    ) {
    }

    public function getMessage(): string
    {
        return $this->message;
    }

    /** @return array<string, mixed> */
    public function getParams(): array
    {
        return $this->params;
    }
}
