<?php

declare(strict_types=1);

namespace Core\General\Helper;

class UrlHelper
{
    /**
     * @param array<string, mixed> $params
     */
    public static function buildUrl(string $baseLink, string $path, array $params = []): string
    {
        $fullPath = \sprintf(
            '%s/%s',
            trim($baseLink, '/'),
            trim($path, '/')
        );

        if (empty($params)) {
            return $fullPath;
        }

        $queryParts = [];

        foreach ($params as $key => $value) {
            $queryParts[] = \sprintf('%s=%s', $key, $value);
        }

        return \sprintf('%s?%s', $fullPath, implode('&', $queryParts));
    }
}
