<?php

declare(strict_types=1);

namespace Core\General\Exception;

final class NotFoundException extends \Exception
{
    private function __construct(string $message = '')
    {
        parent::__construct($message, 404);
    }

    /**
     * @param class-string $className
     */
    public static function becauseEntityNotFound(string $className, int|string|null $id = null): self
    {
        try {
            $shortClassName = (new \ReflectionClass($className))->getShortName();
        } catch (\ReflectionException) {
            $shortClassName = 'Entity';
        }

        if ($id !== null) {
            return new self(\sprintf('%s with ID = %s not found', $shortClassName, $id));
        }

        return new self(\sprintf('%s not found', $shortClassName));
    }
}
