<?php

declare(strict_types = 1);

use Rector\Config\RectorConfig;
use Rector\Doctrine\Set\DoctrineSetList;
use Rector\Symfony\Set\SensiolabsSetList;
use Rector\Symfony\Set\SymfonySetList;

return static function (RectorConfig $rectorConfig): void {
    /*
     * Currently we use rector just as a helper for new PHP attributes feature.
     *
     * To see the full list of available rules, see https://github.com/rectorphp/rector/blob/main/docs/rector_rules_overview.md
     *
     * NOTE: make sure to always run rector in --dry-run mode to prevent unwanted changes in the code.
     */
    $rectorConfig->sets([
        DoctrineSetList::ANNOTATIONS_TO_ATTRIBUTES,
        SymfonySetList::ANNOTATIONS_TO_ATTRIBUTES,
        SensiolabsSetList::ANNOTATIONS_TO_ATTRIBUTES,
    ]);
};
