# Yammat player

## Initial project setup:
- setup docker override configuration
    - copy `docker-compose.override.yml.dist` to `docker-compose.override.yml`
        - update variables like `%!ProjectRootName!%`
            - when you clone this project, it will be `yammat-backend`
            - be careful about `%!UniqueCommitRefSlug!%-nginx`, this one **should be set up** if you are using local domain
            - `frontend` service can be commented out
            - it is by default running through Traefik on a domain `yammat.loc`
                - if you want to use this setup, add `127.0.0.1 yammat.loc` to your `hosts` file (`/etc/hosts`)
- setup .env file
    - copy `.env.dist` file to `.env`
    - set environment variables for your environment or ask someone from the project to give you theirs
- run `make dev`
    - or `sudo make dev` if you have a non-standard setup on your machine

## Namespaces
Namespaces are set up according to the internal DDD policy and is set up through `composer.json` and it's autoload functionality.

When adding a new domain, don't forget to register it in services.

## Useful setups
CI is running on GitLab and checks the following:
- Static analysis
    - with PHPStan on level 8
- Code style fixes
    - with PHP CS Fixer
- Tests
    - all tests written with PHPUnit

To make developing faster and simpler, we have prepared some dev utils that will ease this process:
- Git hooks
    - PHPStan will block commit with message
    - PHP CS Fixer will format your committed code before commit
    - commit message and branch name will be validated according to [our rules](https://gitlab.asynclabs.co/asynclabs/educations-and-workshops/knowledge/-/blob/master/Development/Git-flow.md)
    - **setup:** `make setup_hooks`
    - **cleanup:** `make clear_hooks`
- Checkups for dev process
    - [PHPStan](https://phpstan.org/user-guide/getting-started): `make stan`
    - [PHP CS Fixer](https://github.com/PHP-CS-Fixer/PHP-CS-Fixer): `make csfix`
    - Validate Doctrine scheme `make validate_doctrine_scheme`
    - tests: `make tests` (if tests exist)
    - make `dev_checks` (runs `make stan`, `make csfix` and `make validate_doctrine_scheme` all at once)
- Additional useful bundles included:
    - [Gedmo](https://github.com/doctrine-extensions/DoctrineExtensions)
    - [Rector](https://github.com/rectorphp/rector)

## Git flow
We are following commit message setup and branch naming according to [our rules](https://gitlab.asynclabs.co/asynclabs/educations-and-workshops/knowledge/-/blob/master/Development/Git-flow.md).

These are being enforce with git hooks, as we mentioned earlier.

## Adding new domain
There are several steps to adding a new domain:
1. Create new directory in `src`
    - Create `{bounded-context}-services.yml` in that directory
        - add import for that file in `config/services.yaml`:
            ```
            - { resource: "../src/{BoundedContext}/{bounded-context}-services.yml" }
            ```
    - Create layer directories (Application, Domain, Infrastructure)

2. Add namespace to `composer.json`'s `autoload` section:
    ```
    "{BoundedContext}\\": "src/{BoundedContext}",
    ``` 
3. If you're adding Controllers:
    - define resource section in `{bounded-context}-services.yml` file:
    ```
    {BoundedContext}\Infrastructure\Http\Controller\:
      resource: "Infrastructure/Http/Controller/*"
      tags: ["controller.service_arguments"]
    ``` 
    - Add controller definition to `config/routes/annotations.yaml` if your controllers are not located under these namespaces:
        - `{BoundedContext}/Infrastructure/Http/Controller/Api`
        - `{BoundedContext}/Infrastructure/Http/Controller/Web`

4. If you're adding Twig templates:
    - create directory `src/{BoundedContext}/Infrastructure/Templates`
    - add alias for the domain in `config/packages/twig.yaml`:
    ```
    'src/{BoundedContext}/Infrastructure/Templates': '{BoundedContext}'
    ```
