<?php

use PhpCsFixer\Fixer\Import\OrderedImportsFixer;

$finder = (new PhpCsFixer\Finder)
    ->name('console')
    ->in([
        __DIR__ . '/src',
        __DIR__ . '/migrations',
        __DIR__ . '/tests',
    ]);

return (new PhpCsFixer\Config())
    ->setUsingCache(true)
    ->setRules([
        '@PSR2' => true,
        '@Symfony' => true,
        '@Symfony:risky' => true,
        '@DoctrineAnnotation' => true,
        'concat_space' => ['spacing' => 'one'],
        'array_syntax' => ['syntax' => 'short'],
        'list_syntax' => ['syntax' => 'short'],
        'phpdoc_align' => ['align' => 'left'],
        'phpdoc_no_empty_return' => false,
        'phpdoc_summary' => false,
        'ordered_imports' => [
            'sort_algorithm' => OrderedImportsFixer::SORT_ALPHA,
            'imports_order' => [
                OrderedImportsFixer::IMPORT_TYPE_CONST,
                OrderedImportsFixer::IMPORT_TYPE_FUNCTION,
                OrderedImportsFixer::IMPORT_TYPE_CLASS,
            ],
        ],
        'class_definition' => ['multi_line_extends_each_single_line' => true],
        'ternary_to_null_coalescing' => true,
        'yoda_style' => false,
        'compact_nullable_typehint' => true,
        'visibility_required' => true,
        'no_superfluous_phpdoc_tags' => ['allow_mixed' => true],
        'no_break_comment' => false,
        'ordered_traits' => false,
    ])
    ->setRiskyAllowed(true)
    ->setFinder($finder);
