<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('en', array (
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
    'Too many failed login attempts, please try again later.' => 'Too many failed login attempts, please try again later.',
    'Invalid or expired login link.' => 'Invalid or expired login link.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Too many failed login attempts, please try again in %minutes% minute.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Too many failed login attempts, please try again in %minutes% minutes.',
  ),
  'messages' => 
  array (
    'field_error.required' => 'This field is required',
    'field_error.invalid_value' => 'Invalid value provided. Valid values: %validValues%',
    'field_error.boolean.type' => 'Please provide a valid boolean (true/false) value',
    'field_error.string.type' => 'Please provide a string value',
    'field_error.string.non_empty' => 'Please provide a valid, non-empty string value',
    'field_error.string.length.min' => 'The text should not contain less than %minLength% character(s)',
    'field_error.string.length.max' => 'The text should not contain more than %maxLength% character(s)',
    'field_error.string.length.between' => 'The text should contain %minLength% to %maxLength% character(s)',
    'field_error.string.camel_case' => 'Please provide a valid camelCase string',
    'field_error.string.kebab_case' => 'Please provide a valid kebab-case string',
    'field_error.string.snake_case' => 'Please provide a valid snake_case string',
    'field_error.numeric.type' => 'Please provide a valid numeric value',
    'field_error.numeric.value.min' => 'Please provide a value greater than %minValue%',
    'field_error.numeric.value.max' => 'Please provide a value less than %maxValue%',
    'field_error.numeric.value.between' => 'Please provide a value less than %minValue% and greater than %maxValue%',
    'field_error.integer.type' => 'Please provide a valid integer value',
    'field_error.float.type' => 'Please provide a valid decimal value',
    'field_error.datetime.format.iso8601' => 'Please provide a valid date in ISO8601 format',
    'field_error.datetime.format.ymdhis' => 'Please provide a valid date in Y-m-d H:i:s format',
    'field_error.datetime.format.ymd' => 'Please provide a valid date in Y-m-d format',
    'field_error.datetime.format.his' => 'Please provide a valid time in H:i:s format',
    'field_error.datetime.value.min' => 'Please provide a date after %dateTime%',
    'field_error.datetime.value.max' => 'Please provide a date before %dateTime%',
    'field_error.datetime.value.between' => 'Please provide a date between %startDateTime% and %endDateTime%',
    'field_error.uuid.type' => 'Please provide a valid identifier (uuid) value',
    'field_error.array.value_type.any' => 'Please provide an array',
    'field_error.array.value_type.string' => 'Please provide an array of string values',
    'field_error.array.value_type.uuid' => 'Please provide an array of UUID values',
    'field_error.array.value_type.integer' => 'Please provide an array of integer values',
    'field_error.array.value_type.numeric' => 'Please provide an array of numeric values',
    'field_error.array.value_type.email' => 'Please provide an array of valid email addresses',
    'field_error.array.value_type.object' => 'Please provide an array of objects',
    'field_error.array.value_type.array' => 'Please provide an array of arrays',
    'field_error.array.invalid_values' => 'The array can contain these values only: %validValues%',
    'exception.unexpected' => 'Unexpected error occurred',
    'exception.access_denied' => 'Access denied',
    'exception.unauthorized' => 'Access denied',
    'exception.unprocessable_content' => 'There are some validation errors',
  ),
));

$catalogueHr = new MessageCatalogue('hr', array (
  'security' => 
  array (
    'An authentication exception occurred.' => 'Dogodila se autentifikacijske iznimka.',
    'Authentication credentials could not be found.' => 'Autentifikacijski podaci nisu pronađeni.',
    'Authentication request could not be processed due to a system problem.' => 'Autentifikacijski zahtjev nije moguće provesti uslijed sistemskog problema.',
    'Invalid credentials.' => 'Neispravni akreditacijski podaci.',
    'Cookie has already been used by someone else.' => 'Cookie je već netko drugi iskoristio.',
    'Not privileged to request the resource.' => 'Nemate privilegije zahtijevati resurs.',
    'Invalid CSRF token.' => 'Neispravan CSRF token.',
    'No authentication provider found to support the authentication token.' => 'Nije pronađen autentifikacijski provider koji bi podržao autentifikacijski token.',
    'No session available, it either timed out or cookies are not enabled.' => 'Sesija nije dostupna, ili je istekla ili cookies nisu omogućeni.',
    'No token could be found.' => 'Token nije pronađen.',
    'Username could not be found.' => 'Korisničko ime nije pronađeno.',
    'Account has expired.' => 'Račun je isteko.',
    'Credentials have expired.' => 'Akreditacijski podaci su istekli.',
    'Account is disabled.' => 'Račun je onemogućen.',
    'Account is locked.' => 'Račun je zaključan.',
    'Too many failed login attempts, please try again later.' => 'Previše neuspjelih pokušaja prijave, molim pokušajte ponovo kasnije.',
    'Invalid or expired login link.' => 'Link za prijavu je isteako ili je neispravan.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Previše neuspjelih pokušaja prijave, molim pokušajte ponovo za %minutes% minutu.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Previše neuspjelih pokušaja prijave, pokušajte ponovo za %minutes% minutu.|Previše neuspjelih pokušaja prijave, pokušajte ponovo za %minutes% minute.|Previše neuspjelih pokušaja prijave, pokušajte ponovo za %minutes% minuta.',
  ),
  'messages' => 
  array (
    'field_error.required' => 'Ovo polje je obavezno',
    'field_error.invalid_value' => 'Nedozvoljena vrijednost. Dozvoljene vrijednosti: %validValues%',
    'field_error.boolean.type' => 'Molimo unesite boolean vrijednost (true/false)',
    'field_error.string.type' => 'Ovo polje treba biti tekst',
    'field_error.string.non_empty' => 'Molimo unesite tekst od barem jednog znaka',
    'field_error.string.length.min' => 'Minimalan broj znakova je %minLength%',
    'field_error.string.length.max' => 'Maksimalan broj znakova je %maxLength%',
    'field_error.string.length.between' => 'Broj znakova treba biti između %minLength% i %maxLength%',
    'field_error.string.camel_case' => 'Molimo unesite tekst u camelCase formatu',
    'field_error.string.kebab_case' => 'Molimo unesite tekst u kebab-case formatu',
    'field_error.string.snake_case' => 'Molimo unesite tekst u snake_case formatu',
    'field_error.numeric.type' => 'Molimo unesite brojčanu vrijednost',
    'field_error.numeric.value.min' => 'Molimo unesite vrijednost veću od %minValue%',
    'field_error.numeric.value.max' => 'Molimo unesite vrijednost manju od %maxValue%',
    'field_error.numeric.value.between' => 'Molimo unesite vrijednost veću od %minValue%, a manju od %maxValue%',
    'field_error.integer.type' => 'Molimo unesite cijeli broj',
    'field_error.float.type' => 'Molimo unesite decimalan broj',
    'field_error.datetime.format.iso8601' => 'Molimo unesite datum u ISO8601 formatu',
    'field_error.datetime.format.ymdhis' => 'Molimo unesite datum u Y-m-d H:i:s formatu',
    'field_error.datetime.format.ymd' => 'Molimo unesite datum u Y-m-d formatu',
    'field_error.datetime.format.his' => 'Molimo unesite vrijeme u H:i:s formatu',
    'field_error.datetime.value.min' => 'Molimo unesite datum nakon %dateTime%',
    'field_error.datetime.value.max' => 'Molimo unesite datum prije %dateTime%',
    'field_error.datetime.value.between' => 'Molimo unesite datum između %startDateTime% i %endDateTime%',
    'field_error.uuid.type' => 'Molimo unesite UUID vrijednost',
    'field_error.array.value_type.any' => 'Molimo unesite polje',
    'field_error.array.value_type.string' => 'Molimo unesite polje tekstualnih vrijednosti',
    'field_error.array.value_type.uuid' => 'Molimo unesite polje UUID vrijednosti',
    'field_error.array.value_type.integer' => 'Molimo unesite polje cjelobrojčanih vrijednosti',
    'field_error.array.value_type.numeric' => 'Molimo unesite polje brojčanih vrijednosti',
    'field_error.array.value_type.email' => 'Molimo unesite polje sa valjanim email adresama',
    'field_error.array.value_type.object' => 'Molimo unesite polje objekata',
    'field_error.array.value_type.array' => 'Molimo unesite polje koje se sastoji od polja',
    'field_error.array.invalid_values' => 'Polje smije sadržavati samo sljedeće vrijednosti: %validValues%',
    'exception.unexpected' => 'Dogodila se neočekivana pogreška',
    'exception.access_denied' => 'Pristup onemogućen',
    'exception.unauthorized' => 'Pristup onemogućen',
    'exception.unprocessable_content' => 'Postoje validacijske pogreške',
  ),
));
$catalogue->addFallbackCatalogue($catalogueHr);

return $catalogue;
