<?php

declare(strict_types=1);

namespace Stream\Infrastructure\Mapper;

use Stream\Domain\Model\TimeDetails;

class TimeDetailsMapper
{
    /** @throws \Exception */
    public function mapToDomainObject(string $requestedDateTimeString): TimeDetails
    {
        $dateTimeObject = new \DateTime($requestedDateTimeString);

        $nowDateTimeObject = new \DateTime('now');
        $nowDateTimeObject->modify('-2 minutes');

        $oneHourAgoDateTimeObject = new \DateTime('now');
        $oneHourAgoDateTimeObject->setTime((int) $oneHourAgoDateTimeObject->format('H'), 0);

        $yesterdayDateTimeObject = new \DateTime('now');
        $yesterdayDateTimeObject->modify('-1 day');

        return new TimeDetails(
            $dateTimeObject,
            $nowDateTimeObject,
            $oneHourAgoDateTimeObject,
            $yesterdayDateTimeObject
        );
    }
}
