<?php

declare(strict_types=1);

namespace Core\General\Validation\ValueObject;

final class ValidationResult
{
    private bool $isValid;

    /**
     * @param array<string, mixed> $errorMap
     */
    public function __construct(
        private readonly array $errorMap = [],
        private readonly ?string $customErrorMessage = null)
    {
        $this->isValid = $errorMap === [] && $customErrorMessage === null;
    }

    /** @return array<string, mixed> */
    public function getErrorMap(): array
    {
        return $this->errorMap;
    }

    public function isValid(): bool
    {
        return $this->isValid;
    }

    public function getCustomErrorMessage(): ?string
    {
        return $this->customErrorMessage;
    }

    public function withCustomMessage(string $customErrorMessage): self
    {
        return new self($this->errorMap, $customErrorMessage);
    }
}
