<?php

declare(strict_types=1);

namespace Core\General\Filter\ValueObject;

readonly class SortParameter
{
    public function __construct(
        private string $fieldName,
        private string $orderType,
    ) {
    }

    public function getFieldName(): string
    {
        return $this->fieldName;
    }

    public function getOrderType(): string
    {
        return $this->orderType;
    }
}
