<?php

declare(strict_types=1);

namespace Core\Framework\Command\Handler;

use Core\Framework\Command\Command;

interface CommandHandler
{
    /**
     * All exceptions thrown in specific implementations of this handle method
     * are annotated inside implementation classes.
     *
     * Make sure to handle exceptions properly when using specific handlers.
     */
    public function handle(Command $command): void;
}
